--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNsurfaceParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCsurface
  local LOCstatsMenu
  local LOCuvwRollout
  local LOCdrapeCoordsLocBL = [0.0,0.0] -- Localised draping coords (bottom left) taking shift settings into account
  local LOCdrapeCoordsLocTR = [0.0,0.0] -- Localised draping coords (top right) taking shift settings into account
  local LOCdefDrapeMatID    = 31        -- default material channel for draping bitmaps
  local LOCsetEdgeVis       = true

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNdisplayBitmapName FUNmatID =
  (
    if classOf DYNsurfaceParams.LOCsurface.material == Multimaterial then
    (
      if classOf DYNsurfaceParams.LOCsurface.material.MaterialList[DYNsurfaceParams.SPDYNmatID.value] == StandardMaterial then
      (
        try (DYNsurfaceParams.LBDYNbitmapName.text = DYNuiResourcesLabels[152] + " " + (filenameFromPath DYNsurfaceParams.LOCsurface.material.MaterialList[DYNsurfaceParams.SPDYNmatID.value].diffuseMap.bitmap.fileName)) catch (DYNsurfaceParams.LBDYNbitmapName.text = "")
      )
      if classOf DYNsurfaceParams.LOCsurface.material.MaterialList[DYNsurfaceParams.SPDYNmatID.value] == Arch___Design__mi then
      (
        try (DYNsurfaceParams.LBDYNbitmapName.text = DYNuiResourcesLabels[152] + " " + (filenameFromPath DYNsurfaceParams.LOCsurface.material.MaterialList[DYNsurfaceParams.SPDYNmatID.value].diff_color_map.bitmap.fileName)) catch (DYNsurfaceParams.LBDYNbitmapName.text = "")
      )
    )
    else
    (
      DYNsurfaceParams.LBDYNbitmapName.text = ""
    )
  )

  fn DYNFUNselectFaceSelectionSet FUNobj FUNdnNode =
  (
    if FUNdnNode != undefined then
    (
      if subString FUNdnNode.name 1 1 != "@" and subString FUNdnNode.name 1 1 != "#" then
      (
        deselect FUNobj.faces
      )

      if subString FUNdnNode.name 1 1 == "@" then
      (
        select FUNobj.faces[subString FUNdnNode.name 2 -1]
      )

      if subString FUNdnNode.name 1 1 == "#" then
      (
        local LOCbitArray = FUNobj.Faces as bitArray
        local LOCmatID    = (subString FUNdnNode.name 2 -1) as integer
        for i = 1 to LOCbitArray.count do (if (getFaceMatID FUNobj i) != (LOCmatID) then LOCbitArray[i] = false)
        select FUNobj.faces[LOCbitArray]
      )
    )
    else
    (
      deselect FUNobj.faces
    )
  )

  fn DYNFUNremoveMeshModifiers FUNmesh =
  (
    local LOCsafetoProceed = FUNmesh.modifiers.count == 0 -- boolean (true/false)

    if not LOCsafetoProceed then
    (
      if (CVGetMod DYNsurfaceParams.LOCsurface Civil_View_Spline_to_Mesh) == undefined then
      (
        if (querybox (DYNuiResourcesQueries[11]) title:DYNuiResourcesTitlebars[2]) then
        (
          local LOCsets = DYNFUNsaveFaceSelectionSets LOCobj
          convertToMesh FUNmesh
          DYNFUNretreiveFaceSelectionSets LOCobj LOCsets
          LOCsafetoProceed = true
        )
      )
      else
      (
        LOCsafetoProceed = false
      )
    )
    LOCsafetoProceed
  )

  fn DYNFUNuvwRollout FUNcaption1 FUNcaption2 FUNcaption3 FUNcaption4 FUNcaption5 FUNuvwValue =
  (
    ExeStr=("rollout LOCuvwRollout \"" + FUNcaption1 + "\"\n")
    ExeStr+=("(\n")
    ExeStr+=(" group \"" + FUNcaption2 + "\"\n")
    ExeStr+=(" (\n")
    ExeStr+=("   spinner SPDYNx \"" + FUNcaption5 + " (x):\" range:[0.1,100000," + (FUNuvwValue.X as string) + "]\n")
    ExeStr+=("   spinner SPDYNy \"" + FUNcaption5 + " (y):\" range:[0.1,100000," + (FUNuvwValue.Y as string) + "]\n")
    ExeStr+=("   spinner SPDYNr \"" + FUNcaption3 + "\" range:[-360.0,360.0," + (FUNuvwValue.Z as string) + "]\n")
    ExeStr+=(" )\n")
    ExeStr+=(" button BUDYNclose \"" + FUNcaption4 + "\" align:#center\n")
    ExeStr+=(" on LOCuvwRollout close do\n")
    ExeStr+=(" (\n")
    ExeStr+=(" )\n")

    ExeStr+=(" on SPDYNx changed arg do\n")
    ExeStr+=(" (\n")
    ExeStr+=("   if (CVGetMod DYNsurfaceParams.LOCsurface Civil_View_Spline_to_Mesh) != undefined then ((CVGetMod DYNsurfaceParams.LOCsurface Civil_View_Spline_to_Mesh).length          = arg)\n")
    ExeStr+=("   if (CVGetMod DYNsurfaceParams.LOCsurface UVW_XForm) != undefined then ((CVGetMod DYNsurfaceParams.LOCsurface UVW_XForm).U_Tile         = arg)\n")
    ExeStr+=(" )\n")

    ExeStr+=(" on SPDYNy changed arg do\n")
    ExeStr+=(" (\n")
    ExeStr+=("   if (CVGetMod DYNsurfaceParams.LOCsurface Civil_View_Spline_to_Mesh) != undefined then ((CVGetMod DYNsurfaceParams.LOCsurface Civil_View_Spline_to_Mesh).width            = arg)\n")
    ExeStr+=("   if (CVGetMod DYNsurfaceParams.LOCsurface UVW_XForm) != undefined then ((CVGetMod DYNsurfaceParams.LOCsurface UVW_XForm).V_Tile         = arg)\n")
    ExeStr+=(" )\n")

    ExeStr+=(" on SPDYNr changed arg do\n")
    ExeStr+=(" (\n")
    ExeStr+=("   if (CVGetMod DYNsurfaceParams.LOCsurface Civil_View_Spline_to_Mesh) != undefined then ((CVGetMod DYNsurfaceParams.LOCsurface Civil_View_Spline_to_Mesh).rotation         = arg)\n")
    ExeStr+=("   if (CVGetMod DYNsurfaceParams.LOCsurface UVW_XForm) != undefined then ((CVGetMod DYNsurfaceParams.LOCsurface UVW_XForm).Rotation_Angle = arg)\n")
    ExeStr+=(" )\n")

    ExeStr+=(" on BUDYNclose pressed do destroyDialog LOCuvwRollout\n")
    ExeStr+=(")\n")
    DYNsurfaceParams.LOCuvwRollout = Execute ExeStr
    createDialog DYNsurfaceParams.LOCuvwRollout width:200 height:120 modal:true
  )

  fn DYNFUNchangeSurfaceParamsTab FUNtab =
  (
    local LOCoffset1, LOCoffset2, LOCoffset3
    LOCoffset1 = LOCoffset2 = LOCoffset3 = 0
    if FUNtab == 1 then (LOCoffset1 = 0; LOCoffset2 = LOCoffset3 = -2000; DYNsurfaceParams.LBtabDescription.text = "Data Source")
    if FUNtab == 2 then (LOCoffset2 = 0; LOCoffset1 = LOCoffset3 = -2000; DYNsurfaceParams.LBtabDescription.text = "Surface Statistics")
    if FUNtab == 3 then (LOCoffset3 = 0; LOCoffset1 = LOCoffset2 = -2000; DYNsurfaceParams.LBtabDescription.text = "Bitmap Draping")

    -- Tab 1
    DYNsurfaceParams.GBDYN02.pos.x          = LOCoffset1 + 13
    DYNsurfaceParams.LBDYNmodel01.pos.x     = LOCoffset1 + 22
    DYNsurfaceParams.LBDYNmodel02.pos.x     = LOCoffset1 + 27
    DYNsurfaceParams.LBDYNstring01.pos.x    = LOCoffset1 + 22
    DYNsurfaceParams.LBDYNstring02.pos.x    = LOCoffset1 + 27
    DYNsurfaceParams.GBDYN04.pos.x          = LOCoffset1 + 13
    DYNsurfaceParams.LBDYNimported.pos.x    = LOCoffset1 + 27
    DYNsurfaceParams.GBDYN05.pos.x          = LOCoffset1 + 13
    DYNsurfaceParams.LBDYNsource.pos.x      = LOCoffset1 + 22
    DYNsurfaceParams.LBDYNmodify01.pos.x    = LOCoffset1 + 22
    DYNsurfaceParams.LBDYNmodify02.pos.x    = LOCoffset1 + 27
    DYNsurfaceParams.BUDYNupdate.pos.x      = LOCoffset1 + 13

    -- Tab 2
    DYNsurfaceParams.GBDYN01.pos.x          = LOCoffset2 + 13
    DYNsurfaceParams.LBDYNfaces01.pos.x     = LOCoffset2 + 22
    DYNsurfaceParams.LBDYNpoints01.pos.x    = LOCoffset2 + 22
    DYNsurfaceParams.LBDYNarea.pos.x        = LOCoffset2 + 22
    DYNsurfaceParams.dnStats.pos.x          = LOCoffset2 + 14
    DYNsurfaceParams.CBDYNhighlight.pos.x   = LOCoffset2 + 13

    if FUNtab == 2 then
    (
      if classOf LOCsurface == Editable_mesh then
      (
        local LOCvertCnt    = DYNsurfaceParams.LOCsurface.numverts
        local LOCfaceCnt    = DYNsurfaceParams.LOCsurface.numfaces
        DYNsurfaceParams.LBDYNfaces01.text  = DYNuiResourcesLabels[154] + " " + (LOCfaceCnt as string)
        DYNsurfaceParams.LBDYNpoints01.text = DYNuiResourcesLabels[153] + " " + (LOCvertCnt as string)

        if LOCfaceCnt > 0 then
        (
          --- Adjust Heap Size For Building Array
          if ((LOCfaceCnt * 32) - heapfree) > 0 then
          (
            heapSize += (LOCfaceCnt * 32) - heapfree -- Ensure that enough free memory is availabale
          )

          --- Continue
          local LOCfaceArray  = #() ; LOCfaceArray[LOCfaceCnt] = LOCfaceCnt
          for i = 1 to LOCfaceArray.count do LOCfaceArray[i] = i
          local LOCsurfArea   = meshop.getFaceArea DYNsurfaceParams.LOCsurface LOCfaceArray
          local LOCareaString = ((LOCsurfArea as integer) as string) + (substring ((LOCsurfArea - (LOCsurfArea as integer)) as string) 2 -1)
          DYNsurfaceParams.LBDYNarea.text          = DYNuiResourcesLabels[155] + " " + LOCareaString + " " + (DYNFUNareaUnitsName())
        )

        DYNsurfaceParams.DYNFUNshowBasicSurfaceStatistics LOCsurface
      )
    )
    else
    (
      DYNsurfaceParams.CBDYNhighlight.checked = false
      subObjectLevel = 0
      deselect DYNsurfaceParams.LOCsurface.faces
    )

    -- Tab 3
    DYNsurfaceParams.LBDYNmatID.pos.x       = LOCoffset3 + 22
    DYNsurfaceParams.SPDYNmatID.pos.x       = LOCoffset3 + (DYNiniExplorerWidth - 70)
    DYNsurfaceParams.BUDYNnewMatID.pos.x    = LOCoffset3 + (DYNiniExplorerWidth - 54)
    DYNsurfaceParams.DDDYNselMatID.pos.x    = LOCoffset3 + 22

    DYNsurfaceParams.GBDYN06.pos.x          = LOCoffset3 + 13
    DYNsurfaceParams.BUDYNresetToWrld.pos.x = LOCoffset3 + 22
    DYNsurfaceParams.BUDYNdrapeBitmap.pos.x = LOCoffset3 + 22
    DYNsurfaceParams.LBDYNbitmapName.pos.x  = LOCoffset3 + 22
    DYNsurfaceParams.GBDYN07.pos.x          = LOCoffset3 + 13
    DYNsurfaceParams.LBDYNlocbx.pos.x       = LOCoffset3 + 22
    DYNsurfaceParams.LBDYNlocby.pos.x       = LOCoffset3 + 22
    DYNsurfaceParams.SPDYNlocbx.pos.x       = LOCoffset3 + (DYNiniExplorerWidth - 47)
    DYNsurfaceParams.SPDYNlocby.pos.x       = LOCoffset3 + (DYNiniExplorerWidth - 47)
    DYNsurfaceParams.LBDYNloctx.pos.x       = LOCoffset3 + 22
    DYNsurfaceParams.LBDYNlocty.pos.x       = LOCoffset3 + 22
    DYNsurfaceParams.SPDYNloctx.pos.x       = LOCoffset3 + (DYNiniExplorerWidth - 47)
    DYNsurfaceParams.SPDYNlocty.pos.x       = LOCoffset3 + (DYNiniExplorerWidth - 47)
    DYNsurfaceParams.LBDYNsizx.pos.x        = LOCoffset3 + 22
    DYNsurfaceParams.LBDYNsizy.pos.x        = LOCoffset3 + 22
    DYNsurfaceParams.SPDYNsizx.pos.x        = LOCoffset3 + (DYNiniExplorerWidth - 47)
    DYNsurfaceParams.SPDYNsizy.pos.x        = LOCoffset3 + (DYNiniExplorerWidth - 47)
    DYNsurfaceParams.BUDYNresetToExts.pos.x  = LOCoffset3 + 22

    if FUNtab == 3 then
    (
      local LOCappData426 = getAppData DYNsurfaceParams.LOCsurface 426; if LOCappData426 == undefined then LOCappData426 = ""

      if (subString LOCappData426 1 1) == "@" then
      (
        local LOCdrapeArray = filterString LOCappData426 "|"
        local LOCfirstSetCoords = filterString LOCdrapeArray[2] "$"
        DYNsurfaceParams.LOCdrapeCoordsLocBL.x = try (LOCfirstSetCoords[1] as float) catch (DYNsurfaceParams.LOCsurface.min.x)
        DYNsurfaceParams.LOCdrapeCoordsLocBL.y = try (LOCfirstSetCoords[2] as float) catch (DYNsurfaceParams.LOCsurface.min.y)
        DYNsurfaceParams.LOCdrapeCoordsLocTR.x = try (LOCfirstSetCoords[3] as float) catch (DYNsurfaceParams.LOCsurface.max.x)
        DYNsurfaceParams.LOCdrapeCoordsLocTR.y = try (LOCfirstSetCoords[4] as float) catch (DYNsurfaceParams.LOCsurface.max.y)
      )
      else
      (
        DYNsurfaceParams.LOCdrapeCoordsLocBL.x = try ((execute LOCappData426)[1]) catch (DYNsurfaceParams.LOCsurface.min.x)
        DYNsurfaceParams.LOCdrapeCoordsLocBL.y = try ((execute LOCappData426)[2]) catch (DYNsurfaceParams.LOCsurface.min.y)
        DYNsurfaceParams.LOCdrapeCoordsLocTR.x = try ((execute LOCappData426)[3]) catch (DYNsurfaceParams.LOCsurface.max.x)
        DYNsurfaceParams.LOCdrapeCoordsLocTR.y = try ((execute LOCappData426)[4]) catch (DYNsurfaceParams.LOCsurface.max.y)
      )
      DYNsurfaceParams.DYNFUNdisplayDrapeCoordsInPanel DYNsurfaceParams.LOCdrapeCoordsLocBL DYNsurfaceParams.LOCdrapeCoordsLocTR DYNsurfaceParams.LOCsurface DYNsurfaceParams.SPDYNmatID.value

      DYNsurfaceParams.DYNFUNdisplayBitmapName DYNsurfaceParams.SPDYNmatID.value
    )
  )

  fn DYNFUNsurfaceParams FUNsurface =
  (
    if FUNsurface != undefined then
    (
      if classof FUNsurface == PolymorphicGeom or classof FUNsurface.baseObject == linkLeafShape or classof FUNsurface == LinkComposite then
      (
        DYNsurfaceParams.BUDYNupdate.text = DYNuiResourcesButtons[50]
      )
      if classof FUNsurface == PolymorphicGeom or classof FUNsurface == LinkComposite then
      (
        for i in DYNsurfaceParams.controls do (if classOf i != dotNetControl then i.visible = false)
        DYNsurfaceParams.BUDYNupdate.visible = true
        DYNsurfaceParams.BUDYNupdate.pos.y = 27
        DYNsurfaceParams.LBDYNmodel01.visible = true
        DYNsurfaceParams.LBDYNmodel01.pos = [12,7]
        DYNsurfaceParams.LBDYNmodel01.text = DYNuiResourcesLabels[156]
        DYNsurfaceParams.height = 58
        DYNsurfaceParams.dnTabCtrl.pos.x = 2000
      )
      else
      (
        local LOCappData424 = (getAppData FUNsurface 424) as string
        --- Force repair of AppData 428 to solve potential problems associated with the updating of strings originally imported in V3 Beta when
        --- MX Model Names were not correctly trimmed of blank spaces if imported via MX Model Files
        if (stricmp (getFilenameType LOCappData424) ".fil") == 0 then
        (
          setAppData FUNsurface 428 (DYNFUNstripStringSpaces (subString (getAppData FUNsurface 428) 1 28))
        )

        --- CARRY OUT TAB 1 CHANGES AT THIS STAGE - THESE ARE THE ONLY PARAMETERS WHICH ARE DISPLAYED DIRECTLY
        if (getAppData FUNsurface 422) == "8" then
        (
          DYNsurfaceParams.LBDYNmodel02.text   = DYNFUNdisplayAppDataInUI ((getAppData FUNsurface 428) as string)
          DYNsurfaceParams.LBDYNstring02.text  = DYNFUNdisplayAppDataInUI ((getAppData FUNsurface 427) as string)
          DYNsurfaceParams.LBDYNimported.text  = DYNFUNconvertGUPdate     ((getAppData FUNsurface 425) as string)
          DYNsurfaceParams.LBDYNsource.text    = filenameFromPath LOCappData424

          --- Display File Last Modified Date
          if doesFileExist LOCappData424 then
          (
            if (stricmp (getFilenameType LOCappData424) ".fil") == 0 then
            (
              --- For Model Files
              local LOCmodelName      = (getAppData FUNsurface 428) as string; while LOCmodelName.count < 28 do LOCmodelName += " "
              local LOCmxModelmodDate = DYNFUNgetMxModelFileModelModifyTime LOCappData424 LOCmodelName
              DYNsurfaceParams.LBDYNmodify02.text  = if classOf LOCmxModelmodDate == string then DYNFUNconvertGUPdate LOCmxModelmodDate
            )
            else
            (
              --- For other file types
              DYNsurfaceParams.LBDYNmodify02.text  = DYNFUNconvertGUPdate (DYNFUNgetFileModifyTime LOCappData424 true)
            )
            if (findString DYNsurfaceParams.LBDYNmodify02.text DYNuiResourcesLabels[120]) != undefined then DYNsurfaceParams.LBDYNmodify02.text = "-"
          )
          else
          (
            DYNsurfaceParams.LBDYNmodify02.text  = ""
          )

          DYNsurfaceParams.BUDYNupdate.enabled = if DYNsurfaceParams.LBDYNmodel02.text != "" and DYNsurfaceParams.LBDYNstring02.text != "" then true else false
        )
        else
        (
          DYNsurfaceParams.LBDYNmodel02.text   = DYNuiResourcesLabels[121]
          DYNsurfaceParams.LBDYNstring02.text  = DYNuiResourcesLabels[121]
          DYNsurfaceParams.LBDYNimported.text  = DYNuiResourcesLabels[121]
          DYNsurfaceParams.LBDYNsource.text    = DYNuiResourcesLabels[121]
          DYNsurfaceParams.LBDYNmodify02.text  = DYNuiResourcesLabels[121]
          DYNsurfaceParams.BUDYNupdate.enabled = if classof FUNsurface.baseObject == LinkLeafshape then true else false
        )
      )

      --- Update Material Draping Spinner
      local LOCmat       = FUNsurface.material
      if LOCmat != undefined then
      (
        if classof LOCmat == multiMaterial then
        (
          local LOCidCnt = LOCmat.count
          DYNsurfaceParams.SPDYNmatID.range = [1,LOCidCnt,(if LOCidCnt < LOCdefDrapeMatID then LOCidCnt else LOCdefDrapeMatID)]
        )
        else
        (
          DYNsurfaceParams.SPDYNmatID.range = [LOCdefDrapeMatID,LOCdefDrapeMatID,LOCdefDrapeMatID]
        )
      )
    )
    if classOf LOCsurface != editable_mesh then for i in DYNsurfaceParams.controls do (if classOf i != dotNetControl then i.enabled = false)
  )

  --- Function to adjust Bitmap Draping Controls
  fn DYNFUNdisplayDrapeCoordsInPanel FUNmin FUNmax FUNobj FUNmatID =
  (
    DYNsurfaceParams.SPDYNlocbx.range.y  = -rootNode.DYNrootNodeStore.shiftX + FUNmax.x - 1
    DYNsurfaceParams.SPDYNlocbx.value    = -rootNode.DYNrootNodeStore.shiftX + FUNmin.x
    DYNsurfaceParams.SPDYNloctx.range.x  = -rootNode.DYNrootNodeStore.shiftX + FUNmin.x + 1
    DYNsurfaceParams.SPDYNloctx.value    = -rootNode.DYNrootNodeStore.shiftX + FUNmax.x

    DYNsurfaceParams.SPDYNlocby.range.y  = -rootNode.DYNrootNodeStore.shiftY + FUNmax.y - 1
    DYNsurfaceParams.SPDYNlocby.value    = -rootNode.DYNrootNodeStore.shiftY + FUNmin.y
    DYNsurfaceParams.SPDYNlocty.range.x  = -rootNode.DYNrootNodeStore.shiftY + FUNmin.y + 1
    DYNsurfaceParams.SPDYNlocty.value    = -rootNode.DYNrootNodeStore.shiftY + FUNmax.y

    DYNsurfaceParams.SPDYNsizx.value     = FUNmax.x - FUNmin.x
    DYNsurfaceParams.SPDYNsizy.value     = FUNmax.y - FUNmin.y

    --- Display Drape Array
    local LOCappData426 = getAppData FUNobj 426; if LOCappData426 == undefined then LOCappData426 = ""
    if (subString LOCappData426 1 1) == "@" then
    (
      local LOCmatIDarray = #()
      local LOCdrapeArray = filterString LOCappData426 "|"
      if LOCdrapeArray.count >= 2 then
      (
        for i = 2 to LOCdrapeArray.count do
        (
          local LOCcoordArray = filterString LOCdrapeArray[i] "$"
          if LOCcoordArray.count == 5 then
          (
            append LOCmatIDarray LOCcoordArray[5]
          )
        )
        sort LOCmatIDarray
        DYNsurfaceParams.DDDYNselMatID.items     = LOCmatIDarray
        DYNsurfaceParams.DDDYNselMatID.selection = findItem LOCmatIDarray (FUNMatID as string)
        DYNsurfaceParams.SPDYNmatID.value        = DYNsurfaceParams.DDDYNselMatID.selected as integer
      )
    )
  )

  --- Show only material channel information and face counts (no mat ID surface area info)
  fn DYNFUNshowBasicSurfaceStatistics FUNsurface =
  (
    DYNsurfaceParams.dnStats.nodes.clear()

    ---Build AX Control First Column Definition
    local LOCdnRootNode  = DYNsurfaceParams.dnStats.nodes.Add "" (DYNuiResourcesLabels[157]) 8 8
    local LOCdnMatNode   = LOCdnRootNode.nodes.Add "" (DYNuiResourcesLabels[158]) 37 37
    local LOCdnLinkNode  = LOCdnRootNode.nodes.Add "" (DYNuiResourcesLabels[159]) 37 37
    local LOCdnAsmNode   = LOCdnRootNode.nodes.Add "" (DYNuiResourcesLabels[160]) 37 37
    local LOCdnAsmcNode  = LOCdnRootNode.nodes.Add "" (DYNuiResourcesLabels[161]) 37 37

    --- Add Nodes for Selection Sets
    local LOCselSets     = FUNsurface.faces.selSetNames

    for i in LOCselSets do
    (
      local LOCfilteredSelSetName = filterString i "."
      if LOCfilteredSelSetName[1] == "DVSP" or LOCfilteredSelSetName[1] == "CivilView" then
      (
        if LOCfilteredSelSetName[2] == "SubAsmLink" then
        (
          LOCdnLinkNode.nodes.Add ("@" + (i as string)) ((DYNFUNupperCase (subString i 17 -1) 1) + " (" + (FUNsurface.faces[i].count as string) + ")") 55 55
        )

        if LOCfilteredSelSetName[2] == "SubAsmName" then
        (
          LOCdnAsmNode.nodes.Add ("@" + (i as string)) ((subString i 17 -1) + " (" + (FUNsurface.faces[i].count as string) + ")") 55 55
        )

        if LOCfilteredSelSetName[2] == "SubAsmClass" then
        (
          LOCdnAsmcNode.nodes.Add ("@" + (i as string)) ((subString i 18 -1) + " (" + (FUNsurface.faces[i].count as string) + ")") 55 55
        )
      )
    )

    --- Add Nodes For Each Material ID Used
    local LOCmat       = FUNsurface.material
    if LOCmat != undefined then
    (
      if classof LOCmat == multiMaterial then
      (
        local LOCfaceCnt    = FUNsurface.numfaces                                  -- the number of faces on the current object
        local LOCmatIDnames = DYNFUNgetMatChannelNames LOCmat true true DYNINImatIDlimit           -- get names of material channels for selected object
        local LOCmatIDarray = #(); LOCmatIDarray[LOCmatIDnames.count] = 0          -- Create array to hold number of faces assigned to each material ID
        for i = 1 to LOCmatIDarray.count do LOCmatIDarray[i] = 0                   -- set all channels to zero to indicate that no faces use this material channel

        for i = 1 to LOCfaceCnt do
        (
          if (getFaceMatID FUNsurface i) <= LOCmatIDarray.count then
          (
            LOCmatIDarray[getFaceMatID FUNsurface i] += 1                            -- set material channel to 1 if a face is found which uses this material channel
          )
        )

        --- Display array information in AX control
        local LOCcnt = 0
        for i = 1 to LOCmatIDarray.count do
        (
          if LOCmatIDarray[i] != 0 then
          (
            LOCcnt += 1
            LOCdnMatNode.nodes.add ("#" + (i as string)) (LOCmatIDnames[i] + " (" + (LOCmatIDarray[i] as string) + ")") 23 23
          )
        )
      )
    )
    LOCdnRootNode.expand()
    LOCdnMatNode.expand()
    LOCdnLinkNode.expand()
    LOCdnAsmNode.expand()
    LOCdnAsmcNode.expand()
  )

  fn DYNFUNstatsPopupMenu =
  (
    DYNsurfaceParams.LOCstatsMenu = undefined
    if DYNsurfaceParams.dnStats.selectedNode != undefined then
    (
      rcmenu LOCstatsMenu
      (
        --- Local Variables
        local LOCfaceSelectionSet = ""
        local LOCselmatID = 0
        local LOCobj

        --- Menu Items
        menuItem  MNDYNchangeMat checked:false
        menuItem  MNDYNchangeUVW checked:false
        separator MNDYNseparate0
        menuItem  MNDYNsmooth    checked:false
        separator MNDYNseparate1
        menuItem  MNDYNcalcArea  checked:false
        separator MNDYNseparate2
        menuItem  MNDYNdeleteSet checked:false

        --- Menu Actions
        on LOCstatsMenu open do
        (
          MNDYNchangeMat.text = DYNuiResourcesMenus[36]
          MNDYNchangeUVW.text = DYNuiResourcesMenus[37]
          MNDYNsmooth.text    = DYNuiResourcesMenus[38]
          MNDYNcalcArea.text  = DYNuiResourcesMenus[39]
          MNDYNdeleteSet.text = DYNuiResourcesMenus[40]

          LOCobj              = DYNsurfaceParams.LOCsurface

          local LOCdnStatsKey = DYNsurfaceParams.dnStats.selectedNode.name

          --- Only Enable Menu Items If A Material or Selection Set Item Was Selected
          local LOCenableControls = subString LOCdnStatsKey 1 1 == "@" or subString LOCdnStatsKey 1 1 == "#"
          MNDYNchangeMat.enabled  = LOCenableControls
          MNDYNsmooth.enabled     = LOCenableControls
          MNDYNchangeUVW.enabled  = LOCenableControls
          MNDYNcalcArea.enabled   = LOCenableControls
          MNDYNdeleteSet.enabled  = LOCenableControls

          --- Set Up Selection Set on which any option selected in this menu will operate
          if LOCenableControls then
          (
            LOCselMatID = try ((subString LOCdnStatsKey 2 -1) as integer) catch (0)
            if LOCselMatID == undefined then LOCselMatID = 0

            LOCfaceSelectionSet = LOCobj.selectedFaces as bitArray

            if LOCobj.faces.count == LOCobj.faces[LOCfaceSelectionSet].count then MNDYNdeleteSet.enabled = false

            --- Get Current Draping Coordinates From Selected Surface
            if classOf LOCobj.material == Multimaterial then
            (
              local LOCexistmatIDarray  = #()
              local LOCexistCoordString = getAppData LOCsurface 426; if LOCexistCoordString == undefined then LOCexistCoordString = ""
              local LOCexistCoordArray  = filterString LOCexistCoordString "|"

              if LOCexistCoordArray.count >= 2 then
              (
                for i = 2 to LOCexistCoordArray.count do
                (
                  local LOCarray = filterString LOCexistCoordArray[i] "$"
                  if LOCarray.count == 5 then (append LOCexistmatIDarray (LOCarray[5] as integer))
                )
              )

              MNDYNchangeMat.enabled = true
              MNDYNchangeUVW.enabled = if findItem LOCexistmatIDarray LOCselMatID > 0 then false else true
            )
            else
            (
              MNDYNchangeMat.enabled = false
              MNDYNchangeUVW.enabled = false
            )
          )
        )

        on MNDYNcalcArea picked do
        (
          local LOCareaFloat  = meshop.getFaceArea LOCobj LOCobj.faces[LOCfaceSelectionSet]
          local LOCareaString = ((LOCareaFloat as integer) as string) + (substring ((LOCareaFloat - (LOCareaFloat as integer)) as string) 2 -1)
          messagebox (DYNuiResourcesLabels[164] + " " + LOCareaString + " " + DYNFUNareaUnitsName()) title:DYNuiResourcesTitlebars[3] beep:false
        )

        on MNDYNdeleteSet picked do
        (
          if (DYNsurfaceParams.DYNFUNremoveMeshModifiers LOCobj) then
          (
            if (querybox (DYNuiResourcesQueries[12]) title:DYNuiResourcesTitlebars[2]) then
            (
              meshop.deleteFaces LOCobj LOCobj.faces[LOCfaceSelectionSet] delIsoVerts:true
              update LOCobj
              DYNsurfaceParams.DYNFUNchangeSurfaceParamsTab 2
            )
          )
        )

        on MNDYNsmooth picked do
        (
          local LOCsmoothAngle = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[16] DYNuiResourcesLabels[163] [0.0,180.0,DYNINIfaceSmoothing] "float"
          if LOCsmoothAngle != undefined then
          (
            meshop.autoSmooth LOCobj (LOCobj.faces[LOCfaceSelectionSet] as bitArray) LOCsmoothAngle
            update LOCobj
          )
        )

        on MNDYNchangeMat picked do
        (
          if (DYNsurfaceParams.DYNFUNremoveMeshModifiers LOCobj) then
          (
            --- If Object is a normal surface mesh
            if (querybox (DYNuiResourcesQueries[13]) title:DYNuiResourcesTitlebars[2]) then
            (
              local LOCnewMatID   = DYNFUNdisplayCivilViewSurfacesListBox DYNuiResourcesTitlebars[15] DYNuiResourcesLabels[162] LOCobj.material LOCselMatID
              if classOf LOCselMatID == integer and classOf LOCnewMatID == Integer and LOCnewMatID != LOCselMatID then
              (
                DYNFUNchangeMatIDforSubObj LOCobj LOCselMatID LOCnewMatID LOCfaceSelectionSet
                DYNsurfaceParams.DYNFUNshowBasicSurfaceStatistics LOCobj

                local LOCitem = DYNsurfaceParams.dnStats.nodes.find ("#" + (LOCnewMatID as string)) true
                if LOCitem.count > 0 then DYNsurfaceParams.dnStats.selectedNode = LOCitem[1]
              )
            )
          )
          else
          (
            --- If Object is a shape with a SMesh Modifier Attached
            if (CVGetMod LOCobj Civil_View_Spline_to_Mesh) != undefined then
            (
              if (querybox (DYNuiResourcesQueries[13]) title:DYNuiResourcesTitlebars[2]) then
              (
                local LOCnewMatID   = DYNFUNdisplayCivilViewSurfacesListBox DYNuiResourcesTitlebars[15] DYNuiResourcesLabels[162] LOCobj.material LOCselMatID
                if classOf LOCselMatID == integer and classOf LOCnewMatID == Integer and LOCnewMatID != LOCselMatID then
                (
                  (CVGetMod LOCobj Civil_View_Spline_to_Mesh).matID = LOCnewMatID
                  DYNsurfaceParams.DYNFUNshowBasicSurfaceStatistics LOCobj

                  local LOCitem = DYNsurfaceParams.dnStats.nodes.find ("@" + (LOCnewMatID as string)) true
                  if LOCitem.count > 0 then DYNsurfaceParams.dnStats.selectedNode = LOCitem[1]
                )
              )
            )
          )
        )

        on MNDYNchangeUVW picked do
        (
          if (DYNsurfaceParams.DYNFUNremoveMeshModifiers LOCobj) then
          (
            local LOCsets = DYNFUNsaveFaceSelectionSets LOCobj
            addModifier LOCobj (uvw_xform Rotation_Center:0)
            if (querybox (DYNuiResourcesQueries[14]) title:DYNuiResourcesTitlebars[2]) then
            (
              DYNFUNuvwRollout DYNuiResourcesTitlebars[17] DYNuiResourcesGroups[44] DYNuiResourcesLabels[177] DYNuiResourcesButtons[1] DYNuiResourcesLabels[165] [1.0, 1.0, 0.0]
            )
            convertToMesh LOCobj
            DYNFUNretreiveFaceSelectionSets LOCobj LOCsets
            DYNsurfaceParams.DYNFUNshowBasicSurfaceStatistics LOCobj
          )
          else
          (
            if (CVGetMod LOCobj Civil_View_Spline_to_Mesh) != undefined then
            (
              if (querybox (DYNuiResourcesQueries[14]) title:DYNuiResourcesTitlebars[2]) then
              (
                DYNFUNuvwRollout DYNuiResourcesTitlebars[17] DYNuiResourcesGroups[44] DYNuiResourcesLabels[177] DYNuiResourcesButtons[1] DYNuiResourcesLabels[166] [10,0, 10.0, 0.0]
              )
            )
          )
        )

      )
      registerRightClickMenu DYNsurfaceParams.LOCstatsMenu
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNtab pos:[4,28] width:(DYNiniExplorerWidth - 21) height:353
  dotNetControl dnTabCtrl "System.Windows.Forms.TabControl" height:23  width:(DYNiniExplorerWidth - 21) pos:[4,12]
  label LBDYNtest01 pos:[10,20]
  label LBtabDescription align:#center

  --- Source Tab Controls
  groupbox GBDYN02 width:(DYNiniExplorerWidth - 39) height:132 pos:[2013,57]
  label LBDYNmodel01  align:#left pos:[2022,76]
  label LBDYNmodel02  align:#left pos:[2027,94] width:(DYNiniExplorerWidth - 58) height:38
  label LBDYNstring01 align:#left pos:[2022,130]
  label LBDYNstring02 align:#left pos:[2027,148] width:(DYNiniExplorerWidth - 58) height:38

  groupbox GBDYN04 width:(DYNiniExplorerWidth - 39) height:38 pos:[2013,193]
  label LBDYNimported align:#left pos:[2027,211] width:(DYNiniExplorerWidth - 57)

  groupbox GBDYN05 width:(DYNiniExplorerWidth - 39) height:74 pos:[2013,236]
  label LBDYNsource align:#left pos:[2022,254] width:(DYNiniExplorerWidth - 57)
  label LBDYNmodify01 align:#left pos:[2022,272] width:(DYNiniExplorerWidth - 57)
  label LBDYNmodify02 align:#left pos:[2027,290] width:(DYNiniExplorerWidth - 57)
  button BUDYNupdate width:(DYNiniExplorerWidth - 39)    pos:[2013,317]

  --- Statistics Tab Controls
  groupbox GBDYN01 width:(DYNiniExplorerWidth - 39) height:76 pos:[2013,57]
  label LBDYNfaces01  align:#left pos:[2022,76]
  label LBDYNpoints01 align:#left pos:[2022,94]
  label LBDYNarea     align:#left pos:[2022,112]
  dotNetControl dnStats "System.Windows.Forms.TreeView" height:205 width:(DYNiniExplorerWidth - 41) align:#center pos:[14,140]

  checkbutton CBDYNhighlight width:(DYNiniExplorerWidth - 39) pos:[2013,351]

  --- Draping Tab Controls
  groupbox GBDYN06 width:(DYNiniExplorerWidth - 39) height:69 pos:[2013,57]
  label LBDYNmatID width:85 pos:[2022,76]
  spinner SPDYNmatID "" align:#center fieldwidth:26 type:#integer range:[LOCdefDrapeMatID,LOCdefDrapeMatID,LOCdefDrapeMatID] pos:[2013,76]
  button BUDYNnewMatID width:18 height:16 pos:[2000,76] tooltip:"Add new material channel"
  button BUDYNdrapeBitmap align:#center width:(DYNiniExplorerWidth - 58) pos:[2022,97]

  groupbox GBDYN07 width:(DYNiniExplorerWidth - 39) height:244 pos:[2013,130]
  dropdownList DDDYNselMatID "" pos:[2022,148] width:(DYNiniExplorerWidth - 56)
  label LBDYNbitmapName   align:#center width:(DYNiniExplorerWidth - 58) pos:[2022,173]
  label LBDYNsizx pos:[2022,195]
  label LBDYNsizy pos:[2022,215]
  spinner SPDYNsizx "" align:#right fieldwidth:68 type:#worldUnits range:[0,9999999,0] pos:[2081,194]
  spinner SPDYNsizy "" align:#right fieldwidth:68 type:#worldUnits range:[0,9999999,0] pos:[2081,214]

  label LBDYNlocbx pos:[2022,240]
  label LBDYNlocby pos:[2022,260]
  spinner SPDYNlocbx "" align:#right fieldwidth:68 type:#worldUnits range:[-9999999,9999999,0] pos:[2081,239]
  spinner SPDYNlocby "" align:#right fieldwidth:68 type:#worldUnits range:[-9999999,9999999,0] pos:[2081,259]

  label LBDYNloctx pos:[2022,285]
  label LBDYNlocty pos:[2022,305]
  spinner SPDYNloctx "" align:#right fieldwidth:68 type:#worldUnits range:[-9999999,9999999,0] pos:[2081,284]
  spinner SPDYNlocty "" align:#right fieldwidth:68 type:#worldUnits range:[-9999999,9999999,0] pos:[2081,304]

  button BUDYNresetToExts align:#center width:(DYNiniExplorerWidth - 58) pos:[2022,325]
  button BUDYNresetToWrld align:#center width:(DYNiniExplorerWidth - 58) pos:[2022,348]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNsurfaceParams open do
  (
    DYNsurfaceParams.title = DYNuiRolloutNames[14]

    LBtabDescription.text  = DYNuiResourcesLabels[167]

    GBDYN02.text           = DYNuiResourcesGroups[33]
    GBDYN04.text           = DYNuiResourcesGroups[34]
    GBDYN05.text           = DYNuiResourcesGroups[7]
    GBDYN01.text           = DYNuiResourcesGroups[45]
    GBDYN06.text           = DYNuiResourcesGroups[46]
    GBDYN07.text           = DYNuiResourcesGroups[47]

    BUDYNdrapeBitmap.text  = DYNuiResourcesButtons[32]
    BUDYNupdate.text       = DYNuiResourcesButtons[14]
    BUDYNresetToWrld.text  = DYNuiResourcesButtons[51]
    BUDYNresetToExts.text  = DYNuiResourcesButtons[52]
    CBDYNhighlight.text    = DYNuiResourcesButtons[53]
    BUDYNnewMatID.text     = DYNuiResourcesButtons[54]

    LBDYNmatID.text        = DYNuiResourcesLabels[168]
    LBDYNsizx.text         = DYNuiResourcesLabels[169]
    LBDYNsizy.text         = DYNuiResourcesLabels[170]
    LBDYNlocbx.text        = DYNuiResourcesLabels[171]
    LBDYNlocby.text        = DYNuiResourcesLabels[172]
    LBDYNloctx.text        = DYNuiResourcesLabels[173]
    LBDYNlocty.text        = DYNuiResourcesLabels[174]
    LBDYNmodel01.text      = DYNuiResourcesLabels[51]
    LBDYNstring01.text     = DYNuiResourcesLabels[50]
    LBDYNmodify01.text     = DYNuiResourcesLabels[33]

    local LOCtabNames      = #(DYNuiResourcesLabels[117], DYNuiResourcesLabels[175], DYNuiResourcesLabels[176])
    for i = 1 to LOCtabNames.count do (dntabctrl.tabpages.add LOCtabNames[i])

    LOCsurface             = $

    --- Set Up DN TreeView
    DYNFUNdnTreeViewStyle dnStats
    dnStats.imageList = DYNdnSmImageList

    --- Update DRAPING COORDS to V3.5 (if necessary)
    DYNFUNupdateDrapingCoords LOCsurface

    --- Set Up Panel
    DYNFUNchangeSurfaceParamsTab 1
  )

  on DYNsurfaceParams close do
  (
    if isValidNode LOCsurface then (try (deselect LOCsurface.faces) catch ())
    subObjectLevel = 0

    LOCsurface = undefined
    LOCdrapeCoordsLocBL = [0.0,0.0]
    LOCdrapeCoordsLocTR = [0.0,0.0]
    dnStats.nodes.clear()
  )

  on dnTabCtrl mouseUp arg do
  (
    DYNFUNchangeSurfaceParamsTab (dnTabCtrl.selectedTab.TabIndex + 1)
  )

  on dnStats MouseDown arg1 arg2 do
  (
    local LOCnode = dnStats.getNodeAt arg2.x arg2.y
    if LOCnode != undefined then dnStats.selectedNode = LOCnode
    DYNFUNselectFaceSelectionSet LOCsurface LOCnode

    if keyboard.controlPressed then
    (
      DYNFUNstatsPopupMenu(); if LOCstatsMenu != undefined then popupMenu LOCstatsMenu
    )
  )

  on dnStats MouseUp arg1 arg2 do
  (
    if arg2.button == DYNdnmouseClass.right then
    (
      DYNFUNstatsPopupMenu(); if LOCstatsMenu != undefined then popupMenu LOCstatsMenu
    )
  )

  on SPDYNlocbx changed arg do (LOCdrapeCoordsLocBL.x = arg + rootNode.DYNrootNodeStore.shiftX            ; DYNFUNdisplayDrapeCoordsInPanel LOCdrapeCoordsLocBL LOCdrapeCoordsLocTR LOCsurface SPDYNmatID.value)
  on SPDYNlocby changed arg do (LOCdrapeCoordsLocBL.y = arg + rootNode.DYNrootNodeStore.shiftY            ; DYNFUNdisplayDrapeCoordsInPanel LOCdrapeCoordsLocBL LOCdrapeCoordsLocTR LOCsurface SPDYNmatID.value)
  on SPDYNloctx changed arg do (LOCdrapeCoordsLocTR.x = arg + rootNode.DYNrootNodeStore.shiftX            ; DYNFUNdisplayDrapeCoordsInPanel LOCdrapeCoordsLocBL LOCdrapeCoordsLocTR LOCsurface SPDYNmatID.value)
  on SPDYNlocty changed arg do (LOCdrapeCoordsLocTR.y = arg + rootNode.DYNrootNodeStore.shiftY            ; DYNFUNdisplayDrapeCoordsInPanel LOCdrapeCoordsLocBL LOCdrapeCoordsLocTR LOCsurface SPDYNmatID.value)
  on SPDYNsizx  changed arg do (LOCdrapeCoordsLocTR.x = LOCdrapeCoordsLocBL.x + arg; DYNFUNdisplayDrapeCoordsInPanel LOCdrapeCoordsLocBL LOCdrapeCoordsLocTR LOCsurface SPDYNmatID.value)
  on SPDYNsizy  changed arg do (LOCdrapeCoordsLocTR.y = LOCdrapeCoordsLocBL.y + arg; DYNFUNdisplayDrapeCoordsInPanel LOCdrapeCoordsLocBL LOCdrapeCoordsLocTR LOCsurface SPDYNmatID.value)

  on SPDYNlocbx entered do (DYNFUNapplyPlanarMap LOCsurface [LOCdrapeCoordsLocBL.x,LOCdrapeCoordsLocBL.y] [LOCdrapeCoordsLocTR.x,LOCdrapeCoordsLocTR.y] SPDYNmatID.value)
  on SPDYNlocby entered do (DYNFUNapplyPlanarMap LOCsurface [LOCdrapeCoordsLocBL.x,LOCdrapeCoordsLocBL.y] [LOCdrapeCoordsLocTR.x,LOCdrapeCoordsLocTR.y] SPDYNmatID.value)
  on SPDYNloctx entered do (DYNFUNapplyPlanarMap LOCsurface [LOCdrapeCoordsLocBL.x,LOCdrapeCoordsLocBL.y] [LOCdrapeCoordsLocTR.x,LOCdrapeCoordsLocTR.y] SPDYNmatID.value)
  on SPDYNlocty entered do (DYNFUNapplyPlanarMap LOCsurface [LOCdrapeCoordsLocBL.x,LOCdrapeCoordsLocBL.y] [LOCdrapeCoordsLocTR.x,LOCdrapeCoordsLocTR.y] SPDYNmatID.value)
  on SPDYNsizx  entered do (DYNFUNapplyPlanarMap LOCsurface [LOCdrapeCoordsLocBL.x,LOCdrapeCoordsLocBL.y] [LOCdrapeCoordsLocTR.x,LOCdrapeCoordsLocTR.y] SPDYNmatID.value)
  on SPDYNsizy  entered do (DYNFUNapplyPlanarMap LOCsurface [LOCdrapeCoordsLocBL.x,LOCdrapeCoordsLocBL.y] [LOCdrapeCoordsLocTR.x,LOCdrapeCoordsLocTR.y] SPDYNmatID.value)

  on BUDYNresetToExts pressed do
  (
    LOCdrapeCoordsLocBL = Point2 LOCsurface.min.x LOCsurface.min.y
    LOCdrapeCoordsLocTR = Point2 LOCsurface.max.x LOCsurface.max.y
    DYNFUNdisplayDrapeCoordsInPanel LOCdrapeCoordsLocBL LOCdrapeCoordsLocTR LOCsurface SPDYNmatID.value
    DYNFUNapplyPlanarMap LOCsurface [LOCdrapeCoordsLocBL.x,LOCdrapeCoordsLocBL.y] [LOCdrapeCoordsLocTR.x,LOCdrapeCoordsLocTR.y] SPDYNmatID.value
  )

  on BUDYNresetToWrld pressed do
  (
    if classOf LOCsurface.material == Multimaterial then
    (
      if LOCsurface.material.count >= SPDYNmatID.value then
      (
        local LOCgeoRefCoordArray = DYNFUNgetObjDrapingCoords LOCsurface #() LOCsurface.material true SPDYNmatID.value
        LOCdrapeCoordsLocBL = [LOCgeoRefCoordArray[1],LOCgeoRefCoordArray[2]]
        LOCdrapeCoordsLocTR = [LOCgeoRefCoordArray[3],LOCgeoRefCoordArray[4]]
        DYNFUNdisplayDrapeCoordsInPanel LOCdrapeCoordsLocBL LOCdrapeCoordsLocTR LOCsurface SPDYNmatID.value
        DYNFUNapplyPlanarMap LOCsurface [LOCdrapeCoordsLocBL.x,LOCdrapeCoordsLocBL.y] [LOCdrapeCoordsLocTR.x,LOCdrapeCoordsLocTR.y] SPDYNmatID.value
      )
    )
  )

  on DDDYNselMatID selected arg do
  (
    SPDYNmatID.value = DDDYNselMatID.selected as integer

    --- Should now be able to change tiling coords until a bitmap is specified
    LBDYNsizx.enabled        = true
    LBDYNsizy.enabled        = true
    SPDYNsizx.enabled        = true
    SPDYNsizy.enabled        = true
    LBDYNlocbx.enabled       = true
    LBDYNlocby.enabled       = true
    SPDYNlocbx.enabled       = true
    SPDYNlocby.enabled       = true
    LBDYNloctx.enabled       = true
    LBDYNlocty.enabled       = true
    SPDYNloctx.enabled       = true
    SPDYNlocty.enabled       = true
    BUDYNresetToExts.enabled = true
    BUDYNresetToWrld.enabled = true

    --- See if this matID has been used for draping before
    local LOCexistCoordString = getAppData LOCsurface 426; if LOCexistCoordString == undefined then LOCexistCoordString = ""
    local LOCexistCoordArray  = filterString LOCexistCoordString "|"

    --- Check to see whether this MatID has been used for draping before, and if so update that array entry
    if LOCexistCoordArray.count >= 2 then
    (
      for i = 2 to LOCexistCoordArray.count do
      (
        local LOCcoordArray = filterString LOCexistCoordArray[i] "$"
        if LOCcoordArray.count == 5 then
        (
          if LOCcoordArray[5] == DDDYNselMatID.selected then
          (
            DYNFUNdisplayDrapeCoordsInPanel [LOCcoordArray[1] as float,LOCcoordArray[2] as float] [LOCcoordArray[3] as float,LOCcoordArray[4] as float] LOCsurface SPDYNmatID.value
          )
        )
      )
    )

    DYNFUNdisplayBitmapName SPDYNmatID.value
  )

  on BUDYNnewMatID pressed do
  (
    local LOCmat = LOCsurface.material
    if classof LOCsurface.material == multiMaterial then
    (
      if querybox (DYNuiResourcesQueries[16] + "\n\n" + LOCmat.name) title:DYNuiResourcesTitlebars[3] then
      (
        local LOCcnt = LOCmat.count += 1

        local LOCnewMat
        if (DYNFUNisMentalRayProductionRenderer()) then
        (
          LOCnewMat = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[31] (color 75 110 70) undefined undefined undefined 0.65 true 0.2 1.0 0.0 1.0 8 false 0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
          LOCnewMat.diff_color_map                 = checker()
          LOCnewMat.diff_color_map.coords.U_tiling = 20.0
          LOCnewMat.diff_color_map.coords.V_tiling = 20.0
        )
        else
        (
          LOCnewMat = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[31] (color 75 110 70) (color 75 110 70) (color 75 110 70) 1 undefined undefined undefined 100 0 0.65 true 13 17 0 0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
          LOCnewMat.diffuseMap                 = checker()
          LOCnewMat.diffuseMap.coords.U_tiling = 20.0
          LOCnewMat.diffuseMap.coords.V_tiling = 20.0
        )

        --- Insert Material into Multi/Sub-Object Material
        FUNmat.materiallist[LOCcnt] = LOCnewMat
        FUNmat.names[LOCcnt]        = LOCnewMat.name

        DYNFUNshowTextureMap LOCmat LOCcnt false on

        DYNFUNnodeCreatedCallback()

        SPDYNmatID.range = [1,LOCcnt,LOCcnt]

        --- Should not be able to change tiling coords until a bitmap is specified
        DDDYNselMatID.selection  = 0
        LBDYNsizx.enabled        = false
        LBDYNsizy.enabled        = false
        SPDYNsizx.enabled        = false
        SPDYNsizy.enabled        = false
        LBDYNlocbx.enabled       = false
        LBDYNlocby.enabled       = false
        SPDYNlocbx.enabled       = false
        SPDYNlocby.enabled       = false
        LBDYNloctx.enabled       = false
        LBDYNlocty.enabled       = false
        SPDYNloctx.enabled       = false
        SPDYNlocty.enabled       = false
        BUDYNresetToExts.enabled = false
        BUDYNresetToWrld.enabled = false
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[27]) title:DYNuiResourcesTitlebars[1]
    )
  )

  on SPDYNmatID changed arg do
  (
    local LOCstate = (findItem DDDYNselMatID.items ((arg as integer) as string)) > 0

    --- Should not be able to change tiling coords until a bitmap is specified
    DDDYNselMatID.selection = findItem DDDYNselMatID.items ((arg as integer) as string)
    LBDYNsizx.enabled        = LOCstate
    LBDYNsizy.enabled        = LOCstate
    SPDYNsizx.enabled        = LOCstate
    SPDYNsizy.enabled        = LOCstate
    LBDYNlocbx.enabled       = LOCstate
    LBDYNlocby.enabled       = LOCstate
    SPDYNlocbx.enabled       = LOCstate
    SPDYNlocby.enabled       = LOCstate
    LBDYNloctx.enabled       = LOCstate
    LBDYNlocty.enabled       = LOCstate
    SPDYNloctx.enabled       = LOCstate
    SPDYNlocty.enabled       = LOCstate
    BUDYNresetToExts.enabled = LOCstate
    BUDYNresetToWrld.enabled = LOCstate

    DYNFUNdisplayBitmapName arg
  )

  on BUDYNdrapeBitmap pressed do
  (
    if classOf LOCsurface.material == Multimaterial then
    (
      if LOCsurface.material.count >= SPDYNmatID.value then
      (
        freeSceneBitmaps()
        gc()

        --- Get Bitmap
        local LOCfilename = (getdir #scene) + "\\*.jpg"
        local LOCbitmap = getOpenFileName caption:DYNuiResourcesTitlebars[18] filename:LOCfilename types:DYNimageTypes

        --- See if this matID has been used for draping before
        local LOCexistmatIDarray  = #()
        local LOCexistCoordString = getAppData LOCsurface 426; if LOCexistCoordString == undefined then LOCexistCoordString = ""
        local LOCexistCoordArray  = filterString LOCexistCoordString "|"

        --- Check to see whether this MatID has been used for draping before, and if so update that array entry
        if LOCexistCoordArray.count >= 2 then
        (
          for i = 2 to LOCexistCoordArray.count do
          (
            local LOCcoordArray = filterString LOCexistCoordArray[i] "$"
            if LOCcoordArray.count == 5 then (append LOCexistmatIDarray (LOCcoordArray[5] as integer))
          )
        )

        if LOCbitmap != undefined then
        (
          DYNFUNdisplayMessage DYNuiResourcesTitlebars[3] DYNuiResourcesStatusMessages[18]

          --- Ensure that map is not displayed in viewport otherwise MAX will instantly crash!!!
          DYNFUNshowTextureMap LOCsurface.material SPDYNmatID.value false off

          --- setting this material channel as draping for first time
          if (findItem LOCexistmatIDarray SPDYNmatID.value) == 0 then
          (
            local LOCnewMat
            if (DYNFUNisMentalRayProductionRenderer()) then
            (
              LOCnewMat = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[31] (color 75 110 70) undefined undefined undefined 0.65 true 0.2 1.0 0.0 1.0 8 false 0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
            )
            else
            (
              LOCnewMat = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[31] (color 75 110 70) (color 75 110 70) (color 75 110 70) 1 undefined undefined undefined 100 0 0.65 true 13 17 0 0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
            )

            --- Insert Material into Multi/Sub-Object Material
            FUNmat.materiallist[SPDYNmatID.value] = LOCnewMat
            FUNmat.names[SPDYNmatID.value]        = LOCnewMat.name
          )

          --- Set Up Diffuse Map (always)
          if classOf LOCsurface.material.materiallist[SPDYNmatID.value] == Arch___Design__mi then
          (
            LOCsurface.material.materiallist[SPDYNmatID.value].diff_color_map                       = bitmapTexture()
            LOCsurface.material.materialList[SPDYNmatID.value].diff_color_map_on                    = true
            LOCsurface.material.materialList[SPDYNmatID.value].diff_color_map.fileName              = LOCbitmap
            LOCsurface.material.materiallist[SPDYNmatID.value].diff_color_map.name                  = DYNuiResourcesSurfaceMaterial[31]
            LOCsurface.material.materiallist[SPDYNmatID.value].diff_color_map.coords.blur           = 0.25
            LOCsurface.material.materialList[SPDYNmatID.value].diff_color_map.coords.realWorldScale = false
            LOCsurface.material.materialList[SPDYNmatID.value].diff_color_map.coords.U_tiling       = 1.0
            LOCsurface.material.materialList[SPDYNmatID.value].diff_color_map.coords.V_tiling       = 1.0
            LOCsurface.material.materiallist[SPDYNmatID.value].diff_color_map.coords.W_angle        = 0.0
            LOCsurface.material.materiallist[SPDYNmatID.value].diff_color_map.coords.U_Tile         = false
            LOCsurface.material.materiallist[SPDYNmatID.value].diff_color_map.coords.V_Tile         = false
            LOCsurface.material.materiallist[SPDYNmatID.value].diff_color_map.coords.showMaponBack  = false
          )
          else
          (
            LOCsurface.material.materiallist[SPDYNmatID.value].diffuseMap                           = bitmapTexture()
            LOCsurface.material.materialList[SPDYNmatID.value].diffuseMapAmount                     = 100
            LOCsurface.material.materialList[SPDYNmatID.value].diffuseMapEnable                     = true
            LOCsurface.material.materialList[SPDYNmatID.value].diffuseMap.fileName                  = LOCbitmap
            LOCsurface.material.materiallist[SPDYNmatID.value].diffuseMap.name                      = DYNuiResourcesSurfaceMaterial[31]
            LOCsurface.material.materiallist[SPDYNmatID.value].diffuseMap.coords.blur               = 0.25
            LOCsurface.material.materialList[SPDYNmatID.value].diffuseMap.coords.realWorldScale     = false
            LOCsurface.material.materialList[SPDYNmatID.value].diffuseMap.coords.U_tiling           = 1.0
            LOCsurface.material.materialList[SPDYNmatID.value].diffuseMap.coords.V_tiling           = 1.0
            LOCsurface.material.materiallist[SPDYNmatID.value].diffuseMap.coords.W_angle            = 0.0
            LOCsurface.material.materiallist[SPDYNmatID.value].diffuseMap.coords.U_Tile             = false
            LOCsurface.material.materiallist[SPDYNmatID.value].diffuseMap.coords.V_Tile             = false
            LOCsurface.material.materiallist[SPDYNmatID.value].diffuseMap.coords.showMaponBack      = false
          )

          --- Attempt to Read Corresponding World File (If One Exists)
          local LOCgeoRefCoordArray = DYNFUNgetObjDrapingCoords LOCsurface #() LOCsurface.material true SPDYNmatID.value
          LOCdrapeCoordsLocBL = [LOCgeoRefCoordArray[1],LOCgeoRefCoordArray[2]]
          LOCdrapeCoordsLocTR = [LOCgeoRefCoordArray[3],LOCgeoRefCoordArray[4]]
          destroyDialog DYNmessageRollout

          LBDYNsizx.enabled        = true
          LBDYNsizy.enabled        = true
          SPDYNsizx.enabled        = true
          SPDYNsizy.enabled        = true
          LBDYNlocbx.enabled       = true
          LBDYNlocby.enabled       = true
          SPDYNlocbx.enabled       = true
          SPDYNlocby.enabled       = true
          LBDYNloctx.enabled       = true
          LBDYNlocty.enabled       = true
          SPDYNloctx.enabled       = true
          SPDYNlocty.enabled       = true
          BUDYNresetToExts.enabled = true
          BUDYNresetToWrld.enabled = true

          --- Apply bitmap coords to surface
          DYNFUNapplyPlanarMap LOCsurface [LOCdrapeCoordsLocBL.x,LOCdrapeCoordsLocBL.y] [LOCdrapeCoordsLocTR.x,LOCdrapeCoordsLocTR.y] SPDYNmatID.value
          DYNFUNdisplayDrapeCoordsInPanel LOCdrapeCoordsLocBL LOCdrapeCoordsLocTR LOCsurface SPDYNmatID.value
          if (querybox (DYNuiResourcesQueries[15]) title:DYNuiResourcesTitlebars[2]) then
          (
            DYNFUNshowTextureMap LOCsurface.material SPDYNmatID.value false on
          )
          update LOCsurface

          --- Display Bitmap Name in UI
          DYNFUNdisplayBitmapName SPDYNmatID.value

          gc() -- Otherwise bitmap I/O memory errors can occur on subsequent use of this command
        )
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[29]) title:DYNuiResourcesTitlebars[1]
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[28]) title:DYNuiResourcesTitlebars[1]
    )
  )

  on BUDYNupdate pressed do
  (
    if fileLinkMgr.isAnyLinked LOCsurface then
    (
      DYNFUNloadVSPnodeCallBacks false
      with redraw off
      (
        --- Reload DWG/DXF File (note: currently reloads all DWG files)
        for i = 1 to fileLinkMgr.numLinks do
        (
          fileLinkMgr.reLoad i showUI:true
        )
      )
      redrawViews()

      DYNFUNloadVSPnodeCallBacks true
      DYNFUNnodeCreatedCallback()
      if not isDeleted LOCsurface then select LOCsurface else clearSelection()
    )
    else
    (
      APCFUNupdateImportedObjects #(LOCsurface) true DYNtempPath
      APCFUNupdateAllPlacedObjectControllers()
    )
  )

  on CBDYNhighlight changed arg do
  (
    if arg then
    (
      max Modify Mode
      subObjectLevel = 3
      DYNFUNselectFaceSelectionSet LOCsurface dnStats.selectedNode
    )
    else
    (
      subObjectLevel = 0
      deselect LOCsurface.faces
    )
  )

)

